function dy=kinetics_perfusion_crea(t,y,param)

%--------------------------------------------------------------------------
% Initialization
%--------------------------------------------------------------------------
% Import parameters from main programme

V1=param.V1;         % [dm^3] maternal volume
V2=param.V2;         % [dm^3] trophoblast volume
V3=param.V3;         % [dm^3] fetal volume
A=param.A;           % [dm^2] exchange area

Cinm1=param.Cinm;    % [micro mol/l] maternal inlet concentrations
Fm=param.Fm;         % [dm^3/min] Constant maternal flow 

Cinf1=param.Cinf;    % [micro mol/l] fetal inlet concentrations
%Ff=param.Ff;        % [dm^3/min]Constant fetal flow

% --- Paracellular diffusion:
PdifA=param.PdifA;   % [dm min^-1] diffusive permeability A
PdifB=param.PdifB;   % [dm min^-1] diffusive permeability B
PdifC=param.PdifC;   % [dm min^-1] diffusive permeability C

% --- MVM uptake transporter SERT:
Xt_MVM=param.Xt_MVM;            % number of carriers per membrane area

KA1_MVM=param.KA1_MVM;          % dissociation constant side 1
KB1_MVM=param.KB1_MVM;          % dissociation constant side 1
KA2_MVM=param.KA2_MVM;          % dissociation constant side 2
KB2_MVM=param.KB2_MVM;          % dissociation constant side 2
KK1_MVM=param.KK1_MVM;          % dissociation constant side 1
KK2_MVM=param.KK2_MVM;          % dissociation constant side 2
KNa1_MVM=param.KNa1_MVM;        % dissociation constant side 1
KNa2A_MVM=param.KNa2A_MVM;      % dissociation constant side 2
KNa2B_MVM=param.KNa2B_MVM;      % dissociation constant side 2
kANaX12_MVM=param.kANaX12_MVM;  % forward rate constant
kBNaX12_MVM=param.kBNaX12_MVM;  % forward rate constant
kANaX21_MVM=param.kANaX21_MVM;  % reverse rate constant
kBNaX21_MVM=param.kBNaX21_MVM;  % reverse rate constant
kKX12_MVM=param.kKX12_MVM;      % forward rate constant
kKX21_MVM=param.kKX21_MVM;      % reverse rate constant

% --- Efflux transporter on MVM
VefMVM=param.VefMVM;            % Vmax efflux transporter
KmefMVM=param.KmefMVM;          % Km efflux transporter

% --- BM transporter OCT3:
Xt_BM=param.Xt_BM;              % number of carriers per membrane area

kX12_BM=param.kX12_BM;          % forward rate constant
kX21_BM=param.kX21_BM;          % reverse rate constant

kA12_BM=param.kA12_BM;          % forward rate constant
kA21_BM=param.kA21_BM;          % reverse rate constant
KA1_BM=param.KA1_BM;            % dissociation constant side 1
KA2_BM=param.KA2_BM;            % dissociation constant side 2

kB12_BM=param.kB12_BM;          % forward rate constant
kB21_BM=param.kB21_BM;          % reverse rate constant
KB1_BM=param.KB1_BM;            % dissociation constant side 1
KB2_BM=param.KB2_BM;            % dissociation constant side 2

kC12_BM=param.kC12_BM;          % forward rate constant
kC21_BM=param.kC21_BM;          % reverse rate constant
KC1_BM=param.KC1_BM;            % dissociation constant side 1
KC2_BM=param.KC2_BM;            % dissociation constant side 2
% ---

naa=param.naa;      % number of substrates
ind1=param.ind1;    % index for apical substrates
ind2=param.ind2;    % index for syncytiotrophoblast substrates
ind3=param.ind3;    % index for basal substrates
y1=y(ind1);         % [micro molar] apical concentrations
y2=y(ind2);         % [micro molar] syncytiotrophoblast concentrations
y3=y(ind3);         % [micro molar] basal concentrations
dy1=zeros(naa,1);   % [micro molar/min] rate of change external compartment 1
dy2=zeros(naa,1);   % [micro molar/min] rate of change internal compartment 2
dy3=zeros(naa,1);   % [micro molar/min] rate of change internal compartment 3

CA1=y1(1);          % apical substrate concentration A 
CB1=y1(2);          % apical substrate concentration B
CC1=y1(3);          % apical substrate concentration C

CA2=y2(1);          % syncytiotrophoblast substrate concentration A
CB2=y2(2);          % syncytiotrophoblast substrate concentration B
CC2=y2(3);          % syncytiotrophoblast substrate concentration C

CA3=y3(1);          % basal substrate concentration A
CB3=y3(2);          % basal substrate concentration B
CC3=y3(3);          % basal substrate concentration C


switch param.perfcase
    case 1 % Bidirectional experiments
        if t>=30 && t<58           % maternal 14C
            Ff=param.Fflist(1);    % [dm^3/min] fetal flow
            % Maternal inlet concentrations
            Cinm(1)=Cinm1;         % [uM] inlet concentration A
            Cinm(2)=0;             % [uM] inlet concentration B
            Cinm(3)=0;             % [uM] inlet concentration C
            % Fetal inlet concentrations
            Cinf(1)=0;             % [uM] inlet concentration A
            Cinf(2)=0;             % [uM] inlet concentration B
            Cinf(3)=0;             % [uM] inlet concentration C
        elseif t>=58 && t<88       % maternal 14C + cold
            Ff=param.Fflist(2);    % [dm^3/min] fetal flow
            % Maternal inlet concentrations
            Cinm(1)=Cinm1;         % [uM] inlet concentration A
            Cinm(2)=5e3;           % 5 mM cold metformin(expressed in uM) inlet concentration B
            Cinm(3)=0;             % [uM] inlet concentration C
            % Fetal inlet concentrations
            Cinf(1)=0;             % [uM] inlet concentration A
            Cinf(2)=0;             % [uM] inlet concentration B
            Cinf(3)=0;             % [uM] inlet concentration C
        elseif t>=88 && t<118 % fetal 14C
            Ff=param.Fflist(3);    % [dm^3/min] fetal flow
            % Maternal inlet concentrations
            Cinm(1)=0;             % [uM] inlet concentration A
            Cinm(2)=0;             % [uM] inlet concentration B
            Cinm(3)=0;             % [uM] inlet concentration C
            % Fetal inlet concentrations
            Cinf(1)=Cinf1;         % [uM] inlet concentration A
            Cinf(2)=0;             % [uM] inlet concentration B
            Cinf(3)=0;             % [uM] inlet concentration C
        elseif t>=118 %t<=148  %fetal 14C + cold
            Ff=param.Fflist(4);    % [dm^3/min] fetal flow
            % Maternal inlet concentrations
            Cinm(1)=0;             % [uM] inlet concentration A
            Cinm(2)=0;             % [uM] inlet concentration B
            Cinm(3)=0;             % [uM] inlet concentration C
            % Fetal inlet concentrations
            Cinf(1)=Cinf1;         % [uM] inlet concentration A
            Cinf(2)=5e3;           % 5 mM cold metformin (expressed in uM) inlet concentration B
            Cinf(3)=0;             % [uM] inlet concentration C
        end
 
        
    case 2 % OCT3 experiments
        Cinm(1)=Cinm1;             % [uM] inlet concentration A
        Cinm(2)=0;                 % [uM] inlet concentration B
        Cinm(3)=0;                 % [uM] inlet concentration C
        % Fetal inlet concentrations
        Cinf(1)=0;                 % [uM] inlet concentration A
        Cinf(2)=0;                 % [uM] inlet concentration B
        Cinf(3)=0;                 % [uM] inlet concentration C
        if t>=30 && t<76           % maternal 14C
            Ff=param.Fflist(1);    % [dm^3/min] fetal flow
        elseif t>=76 && t<108
            Ff=param.Fflist(2);    % [dm^3/min] fetal flow
        elseif t>=108 && t<133
            Ff=param.Fflist(3);    % [dm^3/min] fetal flow
        elseif t>=133 && t<158
            Ff=param.Fflist(4);    % [dm^3/min] fetal flow
        elseif t>=158
            Ff=param.Fflist(5);    % [dm^3/min] fetal flow
        end
        
               
        
end




%--------------------------------------------------------------------------
% Transport
%--------------------------------------------------------------------------
dFd=6e-3 - Ff;                          % flow missing from fetal side, producing bulk flow to the maternal compartment

% Flow Maternal compartment:
Qm = Fm*Cinm' - (Fm+dFd)*y1 + dFd*y3;   % [micro mol/min] net influx rate 
dy1 = dy1+Qm/V1;                        % [micro M/min] concentration change due to influx

% Flow Fetal compartment:
Qf = 6e-3*Cinf' - Ff*y3 -dFd*y3;        % [micro mol/min] net influx rate 
dy3 = dy3+Qf/V3;                        % [micro M/min] concentration change due to influx


% --- Compartment 1 to 2: Apical membrane ---



% --- Compartment 2 to 3 --- OCT3 Basal membrane 



% --- Compartment 1 to 3 --- bypassing trophoblast, paracellular diffusion

% Substrate A                  
Q1dif = A*PdifA*(y1(1)-y3(1)); 
dy1(1) = dy1(1) - Q1dif/V1;
dy3(1) = dy3(1) + Q1dif/V3;

% Substrate B
Q2dif = A*PdifB*(y1(2)-y3(2)); 
dy1(2) = dy1(2) - Q2dif/V1;
dy3(2) = dy3(2) + Q2dif/V3;

% Substrate C
Q3dif = A*PdifC*(y1(3)-y3(3)); 
dy1(3) = dy1(3) - Q3dif/V1;
dy3(3) = dy3(3) + Q3dif/V3;


% Output
dy=[dy1;dy2;dy3]; 





